#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
using namespace std;

struct Preticanje {
    int a, b; 
    double t; 
    Preticanje(int a, int b, double t) {
        this->a = a;
        this->b = b;
        this->t = t;
    }
    bool operator<(const Preticanje& other) const {
        return t > other.t;
    }
};

double vreme_preticanja(int x1, int v1, int x2, int v2) {
    if (v1 > v2 && x1 >= x2) return -1;
    if (v2 > v1 && x2 >= x1) return -1;
    if (v1 == v2) return -1;
    return (double)(x2 - x1) / (v1 - v2);
}

double K_to_preticanje(int N, int K, vector<int> x, vector<int> v) {
    priority_queue<Preticanje> red;
    for (int i = 0; i < N; i++) {
        for (int j = i + 1; j < N; j++) {
            double t = vreme_preticanja(x[i], v[i], x[j], v[j]);
            if (t != -1) {
                red.push(Preticanje(i, j, t));
            }
        }
    }
    int broj = 0;
    while (!red.empty()) {
        Preticanje p = red.top();
        red.pop();
        broj++;
        if (broj == K) {
            return p.t;
        }
    }
    return -1;
}

int main() {
    int N, K;
    cin >> N >> K;
    vector<int> x(N), v(N);
    for (int i = 0; i < N; i++) {
        cin >> x[i] >> v[i];
    }
    cout << K_to_preticanje(N, K, x, v) << endl;
    return 0;
}